% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6.R
\name{bedrockdb}
\alias{bedrockdb}
\alias{close.bedrockdb}
\alias{is_bedrockdb}
\title{Open a Bedrock Edition world for reading and writing.}
\usage{
bedrockdb(
  path,
  create_if_missing = FALSE,
  error_if_exists = NULL,
  paranoid_checks = NULL,
  write_buffer_size = 4194304L,
  max_open_files = NULL,
  block_size = 163840L,
  cache_capacity = 83886080L,
  bloom_filter_bits_per_key = 10L,
  compression_level = -1L
)

\method{close}{bedrockdb}(con, compact = FALSE, ...)

is_bedrockdb(x)
}
\arguments{
\item{path}{The path to a world folder. If the path does not exist, it is
assumed to be the base name of a world folder in the local minecraftWorlds
directory.}

\item{create_if_missing}{Create world database if it doesn't exist.}

\item{error_if_exists}{Raise an error if the world database already exists.}

\item{paranoid_checks}{Internal leveldb option}

\item{write_buffer_size}{Internal leveldb option}

\item{max_open_files}{Internal leveldb option}

\item{block_size}{Internal leveldb option}

\item{cache_capacity}{Internal leveldb option}

\item{bloom_filter_bits_per_key}{Internal leveldb option}

\item{compression_level}{Internal leveldb option}

\item{con}{An database object created by bedrockdb.}

\item{compact}{Compact database before closing.}

\item{...}{arguments passed to or from other methods.}

\item{x}{An object.}
}
\value{
On success, \code{bedrockdb} returns an R6 class of type 'bedrockdb'.
}
\description{
\code{bedrockdb} opens a handle to a leveldb database that contains
save-game data for a Bedrock Edition world. On success, it returns
an R6 class of type 'bedrockdb' that can be used directly for
low-level reading and writing access to the db or can be passed to
higher-level functions. The handle to the database can be closed
by passing it to \code{close}.
}
\examples{
# open an example works and get all keys
dbpath <- rbedrock_example_world("example1.mcworld")
db <- bedrockdb(dbpath)
keys <- get_keys(db)
close(db)

\dontrun{

# open a world in the minecraftWorlds folder using a world id.
db <- bedrockdb("lrkkYFpUABA=")
# do something with db ...
close(db)

# open a world using absolute path
db <- bedrockdb("C:\\\\\\\\minecraftWorlds\\\\\\\\my_world")
# do something with db ...
close(db)
}
}
