% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-chunk.R
\name{ChunkNBTData}
\alias{ChunkNBTData}
\alias{get_chunk_nbt_data}
\alias{get_chunk_nbt_value}
\alias{put_chunk_nbt_data}
\alias{put_chunk_nbt_value}
\title{Load and store NBT chunk data}
\usage{
get_chunk_nbt_data(x, z, dimension, tag, subtag, db)

get_chunk_nbt_value(x, z, dimension, tag, subtag, db)

put_chunk_nbt_data(values, x, z, dimension, tag, subtag, db)

put_chunk_nbt_value(value, x, z, dimension, tag, subtag, db)
}
\arguments{
\item{x, z, dimension}{Chunk coordinates to extract data from.
\code{x} can also be a character vector of db keys.}

\item{db}{A bedrockdb object.}

\item{values}{A (named) list of list of NBT objects.}

\item{value}{A list of NBT objects.}
}
\value{
\code{get_chunk_nbt_value()} returns a list of NBT objects.
\code{get_chunk_nbt_data()} returns a named list of lists of NBT objects.
}
\description{
\itemize{
\item \code{get_chunk_nbt_value()} and \code{get_chunk_nbt_data()} load NBT data for a
chunk from \code{db}. \code{get_chunk_nbt_value()} loads NBT data for a single chunk,
and \code{get_chunk_nbt_data()} loads data for multiple chunks.
\item \code{put_chunk_nbt_value()} and \code{put_chunk_nbt_data()} store NBT data for
one or multiple chunks into \code{db}.
}
}
\keyword{internal}
