% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_template.R
\name{get_template}
\alias{get_template}
\title{Copy template files into project}
\usage{
get_template(template_name = NULL, install_to = NULL)
}
\arguments{
\item{template_name}{Optional string. Name of the template to use.
Corresponds to a folder name \verb{templates/}. If NULL (default) within an
interactive session, the function will list available templates and
prompt the user to select one.}

\item{install_to}{Optional string. Directory where the example files
should be copied. If NULL (default), the current working directory
will be used.}
}
\value{
NULL. Called for its side effects: copying template files into
the user's project directory.
}
\description{
\code{get_template} copies example files from the package's \code{templates}
directory into the user's current working directory or a
specified subdirectory.
}
\examples{
if (interactive()) {
  get_template() # prompts user to select an example
}

tmpdir <- file.path(tempdir(), "wastewater_test")
get_template(template_name = "shiny_wastewater", install_to = tmpdir)

# Cleanup
unlink(tmpdir, recursive = TRUE)
}
