% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmdata.R
\name{get_river_aoi}
\alias{get_river_aoi}
\title{Get an area of interest (AoI) around a river, cropping to the bounding box of
a city}
\usage{
get_river_aoi(river, city_bbox, buffer_distance)
}
\arguments{
\item{river}{A list with the river centreline and surface geometries}

\item{city_bbox}{Bounding box around the city}

\item{buffer_distance}{Buffer size around the river}
}
\value{
An sf object in lat/lon coordinates
}
\description{
Get an area of interest (AoI) around a river, cropping to the bounding box of
a city
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bb <- get_osm_bb("Bucharest")
river <- get_osm_river(bb, "Dâmbovița")
get_river_aoi(river, bb, buffer_distance = 100)
\dontshow{\}) # examplesIf}
}
