% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd_sens_cutoff.R
\name{rd_sens_cutoff}
\alias{rd_sens_cutoff}
\title{Cutoff Sensitivity Simulation for Regression Discontinuity}
\usage{
rd_sens_cutoff(object, cutoffs)
}
\arguments{
\item{object}{An object returned by \code{rd_est} or \code{rd_impute}.}

\item{cutoffs}{A numeric vector of cutoff values to be used for refitting 
an \code{rd} object.}
}
\value{
\code{rd_sens_cutoff} returns a dataframe containing the estimate \code{est} and standard error \code{se} 
  for each cutoff value (\code{A1}). Column \code{A1} contains varying cutoffs 
  on the assignment variable. The \code{model} column contains the parametric model (linear, quadratic, or cubic) or 
  non-parametric bandwidth setting (Imbens-Kalyanaraman 2012 optimal, half, or double) used for estimation.
}
\description{
\code{rd_sens_cutoff} refits the supplied model with varying cutoff(s). 
All other aspects of the model, such as the automatically calculated bandwidth, are held constant.
}
\examples{
set.seed(12345)
x <- runif(1000, -1, 1)
cov <- rnorm(1000)
y <- 3 + 2 * x + 3 * cov + 10 * (x >= 0) + rnorm(1000)
rd <- rd_est(y ~ x | cov, t.design = "geq")
rd_sens_cutoff(rd, seq(-.5, .5, length.out = 10))
}
\references{
Imbens, G., Kalyanaraman, K. (2012). 
  Optimal bandwidth choice for the regression discontinuity estimator. 
  The Review of Economic Studies, 79(3), 933-959.
  \url{https://academic.oup.com/restud/article/79/3/933/1533189}.
}
