% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gads_get_keywords.R
\name{gads_get_keywords}
\alias{gads_get_keywords}
\title{Get Keyword Dictionary From Google Ads Client Account}
\usage{
gads_get_keywords(
  customer_id = getOption("gads.customer.id"),
  fields = c("ad_group_criterion.criterion_id", "ad_group_criterion.keyword.text",
    "ad_group_criterion.keyword.match_type", "ad_group_criterion.status",
    "ad_group_criterion.approval_status", "ad_group_criterion.system_serving_status",
    "ad_group_criterion.quality_info.quality_score",
    "ad_group_criterion.quality_info.creative_quality_score",
    "ad_group_criterion.quality_info.post_click_quality_score", "ad_group.id",
    "ad_group.name", "ad_group.status", "campaign.id", "campaign.name", "customer.id",
    "customer.descriptive_name", 
     "metrics.average_cpc", "metrics.average_cost",
    "metrics.ctr", "metrics.bounce_rate"),
  where = NULL,
  order_by = NULL,
  limit = NULL,
  parameters = NULL,
  login_customer_id = getOption("gads.login.customer.id"),
  include_resource_name = FALSE,
  cl = NULL,
  verbose = TRUE
)
}
\arguments{
\item{customer_id}{Google Ads client customer id, supports a single account id: "xxx-xxx-xxxx" or a vector of ids from the same Google Ads MCC: c("xxx-xxx-xxxx", "xxx-xxx-xxxx")}

\item{fields}{character vector, list of report fields, all report has own fields list, for example \href{https://developers.google.com/google-ads/api/fields/v10/keyword_view_query_builder}{see field list of keyword report}.}

\item{where}{Filter, for example you can filter campaigns by status \code{where = "campaign.status = 'ENABLED'"}.}

\item{order_by}{Sorting, character vectors of fields and sorting directions, for example \code{order_by = c("campaign.name DESC", "metrics.clicks")}.}

\item{limit}{Maximun rows in report}

\item{parameters}{Query parameters, for example \code{parameters = "include_drafts=true"}.}

\item{login_customer_id}{Google Ads manager customer id}

\item{include_resource_name}{Get resource names fields in report}

\item{cl}{A cluster object created by \code{\link{makeCluster}}, or an integer to indicate number of child-processes (integer values are ignored on Windows) for parallel evaluations (see Details on performance).}

\item{verbose}{Console log output}
}
\value{
tibble with Keyword criterions dicrionary
}
\description{
Get Keyword Dictionary From Google Ads Client Account
}
\seealso{
\href{https://developers.google.com/google-ads/api/fields/v10/keyword_view_query_builder}{Google Ads Query Builder}
}
