% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_package_host_info.R
\name{get_internal_package_url}
\alias{get_internal_package_url}
\title{Get Internal Package URL}
\usage{
get_internal_package_url(
  package_name,
  version = NULL,
  base_url = "http://cran.us.r-project.org",
  internal_path = "/src/contrib/"
)
}
\arguments{
\item{package_name}{A character string specifying the name of the package.}

\item{version}{An optional character string specifying the version of the package.
Defaults to `NULL`, in which case the latest version will be used.}

\item{base_url}{a character string of internal package manager link}

\item{internal_path}{a character string of internal package mirror link}
}
\value{
A list containing:
  - `url`: A character string of the package URL (or `NULL` if not found).
  - `last_version`: A character string of the latest version of the package.
  - `all_versions`: A character vector of all available package versions.
}
\description{
This function retrieves the URL of an internal package on your internal Mirror, its latest version, 
and a list of all available versions.
}
\examples{
\dontrun{

# Retrieve a specific version URL of a package
result <- get_internal_package_url("internalpackage", version = "1.0.1")
print(result) 
}
}
