% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heartbeat_loops.R
\name{heartbeat}
\alias{heartbeat}
\title{Heartbeat Loop}
\usage{
heartbeat(
  network_id,
  config,
  worker_id,
  heartbeat_period,
  heartbeat_expire,
  pid
)
}
\arguments{
\item{network_id}{(\code{character(1)})\cr
Identifier of the rush network.
Controller and workers must have the same instance id.
Keys in Redis are prefixed with the instance id.}

\item{config}{(\link[redux:redis_config]{redux::redis_config})\cr
Redis configuration options.}

\item{worker_id}{(\code{character(1)})\cr
Identifier of the worker.
Keys in redis specific to the worker are prefixed with the worker id.}

\item{heartbeat_period}{(\code{integer(1)})\cr
Period of the heartbeat in seconds.
The heartbeat is updated every \code{heartbeat_period} seconds.}

\item{heartbeat_expire}{(\code{integer(1)})\cr
Time to live of the heartbeat in seconds.
The heartbeat key is set to expire after \code{heartbeat_expire} seconds.}

\item{pid}{(\code{integer(1)})\cr
Process ID of the worker.}
}
\value{
\code{NULL}
}
\description{
The heartbeat loop updates the heartbeat key if the worker is still alive.
If the kill key is set, the worker is killed.
This function is called in a callr session.
}
\keyword{internal}
