% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SaemixModel.R
\name{validate.covariance.model}
\alias{validate.covariance.model}
\title{Validate the structure of the covariance model}
\usage{
validate.covariance.model(x, verbose = TRUE)
}
\arguments{
\item{x}{a matrix}

\item{verbose}{a boolean indicating whether warnings should be output if x is not a valid covariance model}
}
\value{
a boolean, TRUE if x is an acceptable structure and FALSE if not. Messages will be output to describe why x isn't a valid covariance model if the argument verbose is TRUE.
}
\description{
Check that a matrix corresponds to a structure defining a covariance model for a non-linear mixed effect model.
Such a matrix should be composed of only 0s and 1s, with at least one element set to 1, and should be square and symmetrical.
1s on the diagonal indicate that the corresponding parameter has interindividual variability and that its variance will be estimated.
1s as off-diagonal elements indicate that a covariance between the two corresponding parameters will be estimated.
}
\examples{

covarmodel<-diag(c(1,1,0))
validate.covariance.model(covarmodel) # should return TRUE

}
\seealso{
\code{SaemixModel}
}
\author{
Emmanuelle Comets \href{mailto:emmanuelle.comets@inserm.fr}{emmanuelle.comets@inserm.fr}, Belhal Karimi
}
\keyword{models}
