% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scBSP.R
\name{scBSP}
\alias{scBSP}
\title{A Granularity-Based Approach to identify Spatially Variable Genes}
\usage{
scBSP(Coords, ExpMat_Sp, D_1 = 1.0, D_2 = 3.0, 
Exp_Norm = TRUE, Coords_Norm_Method = c("Sliced", "Overall", "None"), 
K_NN = 100, treetype = "kd")
}
\arguments{
\item{Coords}{A M x D matrix representing D-dimensional coordinates for M spots}

\item{ExpMat_Sp}{A sparse, N x M expression matrix in dgCMatrix class with N genes and M spots}

\item{D_1}{Size of the small patch}

\item{D_2}{Size of the big patch}

\item{Exp_Norm}{A Boolean value indicating whether the expression matrix should be normalized}

\item{Coords_Norm_Method}{Normalization method for the coordinates matrix, which can be "None", "Sliced", or "Overall".}

\item{K_NN}{The maximum number of nearest neighbours to compute.}

\item{treetype}{Character vector specifying the standard 'kd' tree or a 'bd' (box-decomposition, AMNSW98) tree which may perform better for larger point sets.}
}
\value{
A data frame with the name of genes and corresponding p-values.
}
\description{
This function is designed to identify spatially variable genes through a granularity-based approach.
}
\details{
This function utilizes a MxD matrix (Coords) representing D-dimensional coordinates with M spots and a sparse, NxM expression matrix (ExpMat_Sp) with N genes and M spots.
}
\examples{
Coords <- expand.grid(1:100,1:100, 1:3)
RandFunc <- function(n) floor(10 * stats::rbeta(n, 1, 5))
Raw_Exp <- Matrix::rsparsematrix(nrow = 10^4, ncol = 3*10^4, density = 0.0001, rand.x = RandFunc)
Filtered_ExpMat <- SpFilter(Raw_Exp)
rownames(Filtered_ExpMat) <- paste0("Gene_", 1:nrow(Filtered_ExpMat))
P_values <- scBSP(Coords, Filtered_ExpMat)
}
