% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scinsight.R
\docType{class}
\name{scINSIGHT-class}
\alias{scINSIGHT-class}
\alias{scINSIGHT}
\title{The scINSIGHT Class}
\description{
The scINSIGHT object is created from two or more single cell datasets. To construct a
scINSIGHT object, the user needs to provide at least two normalized expression (or another
single-cell modality) matrices and the condition vector.
}
\details{
The key slots used in the scINSIGHT object are described below.
}
\section{Slots}{

\describe{
\item{\code{norm.data}}{List of normalized expression matrices (genes by cells). Each matrix should have the same number and name of genes.}

\item{\code{condition}}{Vector specifying each sample's condition name.}

\item{\code{W_1}}{List of \eqn{W_{\ell1}} estimated by scINSIGHT, names correspond to sample names.}

\item{\code{W_2}}{List of \eqn{W_{\ell2}} estimated by scINSIGHT, names correspond to sample names.}

\item{\code{H}}{List of \eqn{H} estimated by scINSIGHT, names correspond to condition names.}

\item{\code{V}}{Matrix \eqn{V} estimated by scINSIGHT.}

\item{\code{norm.W_2}}{List of \eqn{W_{\ell2}} after normalization. Recommended for downstream analysis.}

\item{\code{clusters}}{List of cluster results.}

\item{\code{parameters}}{List of selected parameters, including \eqn{K} and \eqn{\lambda}.}
}}

