% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_scdf.R
\name{write_scdf}
\alias{write_scdf}
\title{Data output}
\usage{
write_scdf(data, filename = NULL, sep = ",", dec = ".", ...)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link[=scdf]{scdf()}} to learn about this
format.}

\item{filename}{A character string defining the output file name (e.g.
\code{"SC_data.csv"}.}

\item{sep}{The field separator string. Values within each row of x are
separated by this string.}

\item{dec}{The string to use for decimal points in numeric or complex
columns: must be a single character.}

\item{\dots}{Further arguments passed to write.table.}
}
\description{
This function restructures and writes single-case data into a .csv-file.
}
\details{
This is a wrapper for the write.table function with predefined parameters.
}
\examples{
## write single-case data to a .csv-file
filename <- tempfile(fileext = ".csv")
jessica <- random_scdf(design(level = .5))
write_scdf(jessica, tempfile())

## write multiple cases to a .csv-file with semicolon as field and comma as
## decimal separator
write_scdf(Grosche2011, filename, sep = ";", dec = ",")

## read_scdf and write_scdf
write_scdf(exampleA1B1A2B2_zvt, filename)
dat <- read_scdf(filename, cvar = "case", pvar = "part",
                 dvar = "zvt", mvar = "day")
res1 <- describe(exampleA1B1A2B2_zvt)$descriptives
res2 <- describe(dat)$descriptives
all.equal(res1,res2)
}
\seealso{
\code{\link[=write.table]{write.table()}}, \code{\link[=saveRDS]{saveRDS()}}

Other io-functions: 
\code{\link{convert}()},
\code{\link{read_scdf}()}
}
\author{
Juergen Wilbert
}
\concept{io-functions}
\keyword{io}
