% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoutbar.R
\name{scout_action}
\alias{scout_action}
\title{Creates a scout action}
\usage{
scout_action(id, label, description, closeOnClick = TRUE, ...)
}
\arguments{
\item{id}{Unique id.}

\item{label}{Action label.}

\item{description}{Action description.}

\item{closeOnClick}{Whether to close the scoutbar whenever this action is
clicked. Default to TRUE.}

\item{...}{Other options. See \url{https://www.scoutbar.co/docs/actions}.}
}
\value{
A list containing:
\itemize{
\item children: a sublist where are passed the options.
\item class: a character vector to identify the action on the JavaScript side.
You are not expected to modify it as it will break the JavaScript binding.
}
}
\description{
Creates an item that can perform actions on the server side.
}
\details{
This function is meant to be embeded directly within
\link{scoutbar} or via a more structured way within \link{scout_page}
or \link{scout_section}. It serves as a bridge between R and JavaScript to
communicate with the Scoutbar React API, so you are not expected to call it on its
own.
}
