% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_color_pizza.R
\name{scale_color_pizza}
\alias{scale_color_pizza}
\alias{scale_color_pizza_d}
\alias{scale_color_pizza_c}
\alias{scale_colour_pizza}
\alias{scale_colour_pizza_c}
\alias{scale_colour_pizza_d}
\alias{scale_fill_pizza}
\alias{scale_fill_pizza_d}
\alias{scale_fill_pizza_c}
\title{Pizza color palette}
\usage{
scale_color_pizza(
  palette = "margherita",
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_color_pizza_d(
  palette = "margherita",
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_color_pizza_c(
  palette = "margherita",
  discrete = FALSE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_colour_pizza(
  palette = "margherita",
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_colour_pizza_c(
  palette = "margherita",
  discrete = FALSE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_colour_pizza_d(
  palette = "margherita",
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_fill_pizza(
  palette = "margherita",
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "fill",
  ...
)

scale_fill_pizza_d(
  palette = "margherita",
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "fill",
  ...
)

scale_fill_pizza_c(
  palette = "margherita",
  discrete = FALSE,
  reverse = FALSE,
  aesthetics = "fill",
  ...
)
}
\arguments{
\item{palette}{Pizza type. Can be \code{"margherita"} (default), \code{"margherita crust"},
\code{"diavola"} or \code{"diavola crust"}.}

\item{discrete}{Boolean indicating whether color aesthetic is discrete or not.}

\item{reverse}{Boolean indicating whether the palette should be reversed.}

\item{aesthetics}{A vector of names of the aesthetics that this scale
should be applied to (e.g., \code{c('color', 'fill')}).}

\item{...}{Additional arguments to pass to \code{\link[=colorRampPalette]{colorRampPalette()}}.}
}
\description{
The palette based on authentic neapolitan pizzas.
Use \code{scale_color_pizza_d()} for \emph{discrete} categories and
\code{scale_color_pizza_c()} for a \emph{continuous} scale.
}
\examples{
library(ggplot2)
library(see)

ggplot(iris, aes(x = Species, y = Sepal.Length, fill = Species)) +
  geom_boxplot() +
  theme_modern() +
  scale_fill_pizza_d()

ggplot(iris, aes(x = Petal.Length, y = Petal.Width, color = Sepal.Length)) +
  geom_point() +
  theme_modern() +
  scale_color_pizza_c()
}
