% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LM_function.R
\name{LM_model}
\alias{LM_model}
\title{Analysis: Linear regression graph}
\usage{
LM_model(
  trat,
  resp,
  ylab = "Germination (\%)",
  error = "SE",
  xlab = expression("Temperature ("^"o" * "C)"),
  grau = NA,
  theme = theme_classic(),
  cardinal = 0,
  legend.position = "top",
  width.bar = NA,
  scale = "none",
  textsize = 12,
  pointsize = 4.5,
  linesize = 0.8,
  pointshape = 21,
  font.family = "sans"
)
}
\arguments{
\item{trat}{Numerical vector with treatments (Declare as numeric)}

\item{resp}{Numerical vector containing the response of the experiment.}

\item{ylab}{Dependent variable name (Accepts the \emph{expression}() function)}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{xlab}{Independent variable name (Accepts the \emph{expression}() function)}

\item{grau}{Degree of the polynomial (1,2 or 3)}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}

\item{cardinal}{Defines the value of y considered extreme (\emph{default} considers 0 germination)}

\item{legend.position}{Legend position (\emph{default} is "top")}

\item{width.bar}{Bar width}

\item{scale}{Sets x scale (\emph{default} is none, can be "log")}

\item{textsize}{Font size}

\item{pointsize}{shape size}

\item{linesize}{line size}

\item{pointshape}{format point (\emph{default} is 21)}

\item{font.family}{Font family (\emph{default} is sans)}
}
\value{
\describe{
  \item{\code{Coefficients}}{Coefficients and their p values}
  \item{\code{Optimum temperature}}{Optimum temperature (equivalent to the maximum point)}
  \item{\code{Optimum temperature response}}{Response at the optimal temperature (equivalent to the maximum point)}
  \item{\code{Minimal temperature}}{Temperature that has the lowest response}
  \item{\code{Minimal temperature response}}{Lowest predicted response}
  \item{\code{Predicted maximum basal value}}{Lower basal limit temperature based on the value set by the user (default is 0)}
  \item{\code{Predicted minimum basal value}}{Upper basal limit temperature based on the value set by the user (default is 0)}
  \item{\code{AIC}}{Akaike information criterion}
  \item{\code{BIC}}{Bayesian Inference Criterion}
  \item{\code{VIF}}{Variance inflation factor (multicollinearity)}
  \item{\code{r-squared}}{Determination coefficient}
  \item{\code{RMSE}}{Root mean square error}
  \item{\code{grafico}}{Graph in ggplot2 with equation}
  }
}
\description{
Linear regression analysis of an experiment with a quantitative factor or isolated effect of a quantitative factor
}
\note{
If the maximum predicted value is equal to the maximum x, the curve does not have a maximum point within the studied range. If the minimum value is less than the lowest point studied, disregard the value.
}
\examples{
library(seedreg)
data("aristolochia")
attach(aristolochia)

#================================
# Germination
#================================
LM_model(trat,germ, grau=3)

#================================
# Germination speed
#================================
LM_model(trat, vel, grau=3,
ylab=expression("v"~(dias^-1)))
}
\author{
Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
\keyword{linear}
\keyword{regression}
