% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R, R/segen.R
\docType{package}
\name{segen}
\alias{segen}
\alias{segen-package}
\title{segen}
\usage{
segen(
  df,
  seq_len = NULL,
  similarity = NULL,
  dist_method = NULL,
  rescale = NULL,
  smoother = FALSE,
  ci = 0.8,
  error_scale = "naive",
  error_benchmark = "naive",
  n_windows = 10,
  n_samp = 30,
  dates = NULL,
  seed = 42
)
}
\arguments{
\item{df}{A data frame with time features on columns. They could be numeric variables or categorical, but not both.}

\item{seq_len}{Positive integer. Time-step number of the forecasting sequence. Default: NULL (automatic selection between 2 and max limit).}

\item{similarity}{Positive numeric. Degree of similarity between two sequences, based on quantile conversion of distance. Default: NULL (automatic selection between 0.01, maximal difference, and 0.99, minimal difference).}

\item{dist_method}{String. Method for calculating distance among sequences. Available options are: "euclidean", "manhattan", "maximum", "minkowski". Default: NULL (random search).}

\item{rescale}{Logical. Flag to TRUE for min-max scaling of distances. Default: NULL (random search).}

\item{smoother}{Logical. Flag to TRUE for loess smoothing. Default: FALSE.}

\item{ci}{Confidence interval for prediction. Default: 0.8}

\item{error_scale}{String. Scale for the scaled error metrics (for continuous variables). Two options: "naive" (average of naive one-step absolute error for the historical series) or "deviation" (standard error of the historical series). Default: "naive".}

\item{error_benchmark}{String. Benchmark for the relative error metrics (for continuous variables). Two options: "naive" (sequential extension of last value) or "average" (mean value of true sequence). Default: "naive".}

\item{n_windows}{Positive integer. Number of validation windows to test prediction error. Default: 10.}

\item{n_samp}{Positive integer. Number of samples for random search. Default: 30.}

\item{dates}{Date. Vector with dates for time features.}

\item{seed}{Positive integer. Random seed. Default: 42.}
}
\value{
This function returns a list including:
\itemize{
\item exploration: list of all not-null models, complete with predictions and error metrics
\item history: a table with the sampled models, hyper-parameters, validation errors
\item best_model: results for the best selected model according to the weighted average rank, including:
\itemize{
\item predictions: for continuous variables, min, max, q25, q50, q75, quantiles at selected ci, mean, sd, mode, skewness, kurtosis, IQR to range, risk ratio, upside probability and divergence for each point fo predicted sequences; for factor variables, min, max, q25, q50, q75, quantiles at selected ci, proportions, difformity (deviation of proportions normalized over the maximum possible deviation), entropy, upgrade probability and divergence for each point fo predicted sequences
\item testing_errors: testing errors for each time feature for the best selected model (for continuous variables: me, mae, mse, rmsse, mpe, mape, rmae, rrmse, rame, mase, smse, sce, gmrae; for factor variables: czekanowski, tanimoto, cosine, hassebrook, jaccard, dice, canberra, gower, lorentzian, clark)
\item plots: standard plots with confidence interval for each time feature
}
\item time_log
}
}
\description{
Sequence Generalization Through Similarity Network
}
\examples{
segen(time_features[, 1, drop = FALSE], seq_len = 30, similarity = 0.7, n_windows = 3, n_samp = 1)


}
\seealso{
Useful links:
\itemize{
  \item \url{https://rpubs.com/giancarlo_vercellino/segen}
}

}
\author{
Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com}
}
