% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global_min_max.R
\name{global_min_max}
\alias{global_min_max}
\title{Global minimum and maximum of a real-valued continuous function over a closed interval}
\usage{
global_min_max(f, f1der, f2der, D)
}
\arguments{
\item{f}{function expression}

\item{f1der}{function expression of first derivative of \code{f}}

\item{f2der}{function expression of second derivative of \code{f}}

\item{D}{numeric vector specifying the interval over which \code{f}
is optimized}
}
\value{
A list containing:
\item{min}{numeric giving critical point where global minimum is achieved}
\item{max}{numeric giving critical point where global maximum is achieved}
\item{mins}{numeric vector giving all critical points satisfying second 
derivative criterion for minimum}
\item{maxs}{numeric vector giving all critical points satisfying second 
derivative criterion for maximum}
}
\description{
Gets global minimum and maximum of a given function expression
on an interval using basic calculus criteria
}
\details{
This function uses \code{\link[rootSolve]{uniroot.all}}
to get all roots of \code{f1der} over \code{D}, additionally,
the second derivative criterion is used to determine the global minimum and
maximum.
}
\seealso{
\code{\link{phenopar}}, \code{\link[rootSolve]{uniroot.all}}
}
