% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqminer.R
\name{rvmeta.writeScoreData}
\alias{rvmeta.writeScoreData}
\title{Write score-based association statistics files.}
\usage{
rvmeta.writeScoreData(rvmetaData, outName, createIndex = FALSE)
}
\arguments{
\item{rvmetaData}{a list vector. It's usually read by rvmeta.readDataByRange or rvmeta.readDataByGene function}

\item{outName}{character, a text indicating output file prefix}

\item{createIndex}{boolean, (default FALSE), whether or not to create the index}
}
\value{
TRUE only if succeed
}
\description{
Write score-based association statistics files.
}
\examples{
scoreFileName = system.file("rvtests/rvtest.MetaScore.assoc.anno.gz", package = "seqminer")
covFileName = system.file("rvtests/rvtest.MetaCov.assoc.gz", package = "seqminer")
geneFile = system.file("vcf/refFlat_hg19_6col.txt.gz", package = "seqminer")
cfh <- rvmeta.readDataByRange(scoreFileName, covFileName, "1:196621007-196716634")

outFile <- file.path(tempdir(), "cfh.MetaScore.assoc")
rvmeta.writeScoreData(cfh, outFile)
cat('Outputted MetaScore file are in the temp directory:', outFile, '\n')
}
\seealso{
http://zhanxw.com/seqminer/ for online manual and examples
}
