% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRelM.R
\name{GetRelM}
\alias{GetRelM}
\title{Matrix with Pairwise Relationships}
\usage{
GetRelM(
  Pedigree = NULL,
  Pairs = NULL,
  GenBack = 1,
  patmat = FALSE,
  directed = TRUE,
  Return = "Matrix",
  Pairs_suffix = "?"
)
}
\arguments{
\item{Pedigree}{dataframe with columns id - dam - sire.}

\item{Pairs}{dataframe with columns ID1 - ID2 - Rel, e.g. as returned by
\code{\link{GetMaybeRel}}. Combining \code{Pedigree} and \code{Pairs} works
best if the relationships are coded as listed below.}

\item{GenBack}{number of generations back to consider; 1 returns
parent-offspring and sibling relationships, 2 also returns grand-parental,
avuncular and first cousins.}

\item{patmat}{logical, distinguish between paternal versus maternal relative
pairs? For avuncular pairs, the distinction is never made.}

\item{directed}{logical, distinguish between e.g. ID1=offspring, ID2=mother
('M') and ID1=mother, ID2=offspring ('O')? Defaults to TRUE; if FALSE both
are are scored as 'PO', as are father-offspring pairs, and all
grandparent-- grand-offspring pairs are scored as 'GPO', and avuncular
pairs as 'FNA' and 'HNA'. Not (currently) compatible with \code{patmat}.
When \code{Return}='List', each pair is included twice (as ID1-ID2 &
ID2-ID1)}

\item{Return}{'Matrix', 'Array', or 'List'. 'Matrix' returns an N x N matrix
with the closest relationship between each pair. 'Array' returns an N x N x
R array with for each of the R considered relationships whether it exists
between the pair (1) or not (0). See Details below. 'List' returns a list
with for each of the R considered relationships a 2-column matrix with the
IDs of the pairs having such a relationship. The size of the list (in Mb)
is much smaller than for the matrix or array, and this is therefore the
only format suitable for pedigrees with many thousands of individuals. If
\code{Pairs} is specified, the only possible return type is 'Matrix'.}

\item{Pairs_suffix}{symbol added to the relationship abbreviations derived
from \code{Pairs}, when both \code{Pedigree} and \code{Pairs} are
provided. Can be an empty string.}
}
\value{
If \code{Return='Matrix'}, an N x N square matrix, with N equal to
  the number of rows in \code{Pedigree} (after running
  \code{\link{PedPolish}}) or the number of unique individuals in
  \code{Pairs}. If \code{Return='Array'}, an N x N x R array is returned,
  with R, the number of different relationships, determined by \code{GenBack}
  and \code{patmat}.

 The following abbreviations are used within the returned \code{Matrix}, or
 as names of the 3rd dimension in the \code{Array} or of the \code{List}:
   \item{S}{Self}
   \item{M}{Mother}
   \item{P}{Father}
   \item{MP}{Mother or Father (\code{patmat=FALSE})}
   \item{O}{Offspring}
   \item{FS}{Full sibling}
   \item{MHS}{Maternal half-sibling}
   \item{PHS}{Paternal half-sibling}
   \item{XHS}{other half-sibling (hermaphrodites)}
   \item{HS}{half-sibling (\code{patmat=FALSE})}
   \item{MGM}{Maternal grandmother}
   \item{MGF}{Maternal grandfather}
   \item{PGM}{Paternal grandmother}
   \item{PGF}{Paternal grandfather}
   \item{GP}{Grandparent (\code{patmat=FALSE})}
   \item{GO}{Grand-offspring}
   \item{FA}{Full avuncular; maternal or paternal aunt or uncle.}
   \item{FN}{Full nephew/niece}
   \item{HA}{Half avuncular}
   \item{HN}{Half nephew/niece}
   \item{DFC1}{Double full first cousin}
   \item{FC1}{Full first cousin}
   \item{U}{Unrelated (or otherwise related)}
}
\description{
Generate a matrix or 3D array with all pairwise relationships
  from a pedigree or dataframe with pairs.
}
\details{
Double relationships are ignored when \code{Return='Matrix'}, but
  not when \code{Return='Array'}. For example, when A and B are both
  mother-offspring and paternal siblings (A mated with her father to produce
  B), only the mother-offspring relationship will be indicated when
  \code{Return='Matrix'}.

  Note that full siblings are the exception to this rule: in the \code{Array}
  they will be indicated as 'FS' only, and not as 'MHS' or 'PHS'. Similarly,
  full avuncular pairs are not indicated as 'HA'. Double half-avuncular
  relationships are indicated as both FA and HA.

  When \code{Pairs} is provided, \code{GenBack} and \code{patmat} are
  ignored, and no check is performed if the abbreviations are compatible with
  other functions.
}
\examples{
Rel.griffin <- GetRelM(Ped_griffin, directed=FALSE)  # few categories
Rel.griffin <- GetRelM(Ped_griffin, patmat=TRUE, GenBack=2)  # many cat.
table(as.vector(Rel.griffin))
# turning matrix into vector first makes table() much faster
PlotRelPairs(Rel.griffin)

}
\seealso{
\code{\link{ComparePairs}} for comparing pairwise relationships
  between two pedigrees; \code{\link{PlotRelPairs}}.
}
