% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.cs.R
\name{sim.cs}
\alias{sim.cs}
\title{Simulate a cross-sectional serosurvey with noise}
\usage{
sim.cs(
  lambda = 0.1,
  n.smpl = 100,
  age.rng = c(0, 20),
  age.fx = NA,
  antigen_isos,
  n.mc = 0,
  renew.params = FALSE,
  add.noise = FALSE,
  curve_params,
  noise_limits,
  format = "wide",
  verbose = FALSE,
  ...
)
}
\arguments{
\item{lambda}{a \code{\link[=numeric]{numeric()}} scalar indicating the incidence rate (in events per person-years)}

\item{n.smpl}{number of samples to simulate}

\item{age.rng}{age range of sampled individuals, in years}

\item{age.fx}{specify the curve parameters to use by age (does nothing at present?)}

\item{antigen_isos}{Character vector with one or more antibody names. Values must match \code{curve_params}.}

\item{n.mc}{how many MCMC samples to use:
\itemize{
\item when \code{n.mc} is in \code{1:4000} a fixed posterior sample is used
\item when \code{n.mc} = \code{0}, a random sample is chosen
}}

\item{renew.params}{whether to generate a new parameter set for each infection
\itemize{
\item \code{renew.params = TRUE} generates a new parameter set for each infection
\item \code{renew.params = FALSE} keeps the one selected at birth, but updates baseline y0
}}

\item{add.noise}{a \code{\link[=logical]{logical()}} indicating whether to add biological and measurement noise}

\item{curve_params}{a \code{\link[=data.frame]{data.frame()}} containing MCMC samples of parameters
from the Bayesian posterior distribution of a longitudinal decay curve model.
The parameter columns must be named:
\itemize{
\item \code{antigen_iso}: a \code{\link[=character]{character()}} vector indicating antigen-isotype
combinations
\item \code{iter}: an \code{\link[=integer]{integer()}} vector indicating MCMC sampling iterations
\item \code{y0}: baseline antibody level at $t=0$ ($y(t=0)$)
\item \code{y1}: antibody peak level (ELISA units)
\item \code{t1}: duration of infection
\item \code{alpha}: antibody decay rate
(1/days for the current longitudinal parameter sets)
\item \code{r}: shape factor of antibody decay
}}

\item{noise_limits}{biologic noise distribution parameters}

\item{format}{a \code{\link[=character]{character()}} variable, containing either:
\itemize{
\item \code{"long"} (one measurement per row) or
\item \code{"wide"} (one serum sample per row)
}}

\item{verbose}{logical: if TRUE, print verbose log information to console}

\item{...}{additional arguments passed to \code{simcs.tinf()}}
}
\value{
a \link[tibble:tbl_df-class]{tibble::tbl_df} containing simulated cross-sectional serosurvey data, with columns:
\itemize{
\item \code{age}: age (in days)
\item one column for each element in the \code{antigen_iso} input argument
}
}
\description{
Makes a cross-sectional data set (age, y(t) set)
and adds noise, if desired.
}
\examples{
# Load curve parameters
curve <-
  typhoid_curves_nostrat_100

# Specify the antibody-isotype responses to include in analyses
antibodies <- c("HlyE_IgA", "HlyE_IgG")

# Set seed to reproduce results
set.seed(54321)

# Simulated incidence rate per person-year
lambda <- 0.2;

# Range covered in simulations
lifespan <- c(0, 10);

# Cross-sectional sample size
nrep <- 100

# Biologic noise distribution
dlims <- rbind(
  "HlyE_IgA" = c(min = 0, max = 0.5),
  "HlyE_IgG" = c(min = 0, max = 0.5)
)

# Generate cross-sectional data
csdata <- sim.cs(
  curve_params = curve,
  lambda = lambda,
  n.smpl = nrep,
  age.rng = lifespan,
  antigen_isos = antibodies,
  n.mc = 0,
  renew.params = TRUE,
  add.noise = TRUE,
  noise_limits = dlims,
  format = "long"
)

}
