% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfcr_validate.R
\name{sfcr_validate}
\alias{sfcr_validate}
\title{Validate a transactions-flow or balance-sheet matrix}
\usage{
sfcr_validate(matrix, baseline, which, tol = 1, rtol = FALSE)
}
\arguments{
\item{matrix}{A transactions-flow or balance sheet matrix}

\item{baseline}{A baseline model.}

\item{which}{Either "bs" (balance-sheet matrix) or "tfm" (transactions-flow matrix).}

\item{tol}{A numerical value indicating the absolute accepted discrepancy accepted
to validate whether the rows and columns are equal to their expected values.}

\item{rtol}{A logical value indicating whether relative discrepancies should be
evaluated. It defaults to \code{FALSE}. Stationary models should pass the test using
a absolute level while growth models might need a relative validation since computational
discrepancies tend to get larger with the model. See details for further information.}
}
\description{
This function validates a transactions-flow or balance-sheet
matrix with the simulated data obtained with \code{sfcr_baseline()}
function
}
\details{
The relative discrepancy is calculated differently if we are dealing with a
transactions-flow matrix or with a balance-sheet matrix. If \code{which} is set to \code{tfm},
the sum of the row/column is evaluated against the sum of the positive entries of that row/column.

For example, in a transactions-flow matrix with three entries in the "change in the stock of bills"
row (-Delta (Bhd), + Delta (Bs), and + Delta (Bbd)), the discrepancy d = Delta Bs - Delta Bhd - Delta Bbd
is evaluated against Delta Bs, i.e., the row is validated if d/Delta Bs < tol.

In a balance-sheet matrix, all the rows/columns that sum to zero are validated exactly as
in a transactions-flow matrix. The exception to this rule is when there is a expected value. In this case,
the discrepancy is evaluated as a proportion of the expected. value

To prevent unnecessary calculations, a absolute check with tolerance defined as 1e-3 is executed
prior to this evaluation.

The absolute discrepancy set with \code{tol} should be enough to validate
a stationary SFC Model.
}
\author{
João Macalós
}
