% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approach_empirical.R
\name{observation_impute}
\alias{observation_impute}
\title{Generate permutations of training data using test observations}
\usage{
observation_impute(
  W_kernel,
  S,
  x_train,
  x_explain,
  empirical.eta = 0.7,
  n_MC_samples = 1000
)
}
\arguments{
\item{W_kernel}{Numeric matrix. Contains all nonscaled weights between training and test
observations for all coalitions. The dimension equals \verb{n_train x m}.}

\item{S}{Integer matrix of dimension \verb{n_coalitions x m}, where \code{n_coalitions}
and \code{m} equals the total number of sampled/non-sampled coalitions and
the total number of unique features, respectively. Note that \code{m = ncol(x_train)}.}

\item{x_train}{Data.table with training data.}

\item{x_explain}{Data.table with the features of the observation whose
predictions ought to be explained (test data).}
}
\value{
data.table
}
\description{
Generate permutations of training data using test observations
}
\author{
Nikolai Sellereite
}
\keyword{internal}
