% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PFER.R
\name{PFER}
\alias{PFER}
\title{Per Family Error Rate}
\usage{
PFER(q, pi, N, K, PFER_method = "MB")
}
\arguments{
\item{q}{average number of features selected by the underlying algorithm.}

\item{pi}{threshold in selection proportions.}

\item{N}{total number of features.}

\item{K}{number of resampling iterations.}

\item{PFER_method}{method used to compute the upper-bound of the expected
number of False Positives (or Per Family Error Rate, PFER). If
\code{PFER_method="MB"}, the method proposed by Meinshausen and Bühlmann
(2010) is used. If \code{PFER_method="SS"}, the method proposed by Shah and
Samworth (2013) under the assumption of unimodality is used.}
}
\value{
The estimated upper-bound in PFER.
}
\description{
Computes the Per Family Error Rate upper-bound of a stability selection model
using the methods proposed by Meinshausen and Bühlmann (2010) or Shah and
Samworth (2013). In stability selection, the PFER corresponds to the expected
number of stably selected features that are not relevant to the outcome (i.e.
False Positives).
}
\examples{
# Computing PFER for 10/50 selected features and threshold of 0.8
pfer_mb <- PFER(q = 10, pi = 0.8, N = 50, K = 100, PFER_method = "MB")
pfer_ss <- PFER(q = 10, pi = 0.8, N = 50, K = 100, PFER_method = "SS")
}
\references{
\insertRef{stabilityselectionMB}{sharp}

  \insertRef{stabilityselectionSS}{sharp}
}
\seealso{
Other stability metric functions: 
\code{\link{ConsensusScore}()},
\code{\link{FDP}()},
\code{\link{StabilityMetrics}()},
\code{\link{StabilityScore}()}
}
\concept{stability metric functions}
