% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_plot.R
\name{plot.roc_band}
\alias{plot.roc_band}
\title{Receiver Operating Characteristic (ROC) band}
\usage{
\method{plot}{roc_band}(
  x,
  col_band = NULL,
  alpha = 0.5,
  quantiles = c(0.05, 0.95),
  add = FALSE,
  ...
)
}
\arguments{
\item{x}{output of \code{\link[fake]{ROC}} or \code{\link{ExplanatoryPerformance}}.}

\item{col_band}{colour of the band defined by point-wise \code{quantiles}.}

\item{alpha}{level of opacity for the band.}

\item{quantiles}{point-wise quantiles of the performances defining the band.}

\item{add}{logical indicating if the curve should be added to the current
plot.}

\item{...}{additional plotting arguments (see \code{\link[graphics]{par}}).}
}
\value{
A base plot.
}
\description{
Plots the True Positive Rate (TPR) as a function of the False Positive Rate
(FPR) for different thresholds in predicted probabilities. If the results
from multiple ROC analyses are provided (e.g. output of
\code{\link{ExplanatoryPerformance}} with large \code{K}), the point-wise
median is represented and flanked by a transparent band defined by point-wise
\code{quantiles}. See examples in \code{\link[fake]{ROC}} and
\code{\link{ExplanatoryPerformance}}.
}
\seealso{
\code{\link[fake]{ROC}}, \code{\link{ExplanatoryPerformance}}
}
