% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_hist_f.R
\name{plot_hist}
\alias{plot_hist}
\title{Extract values from a raster to produce a histogram}
\usage{
plot_hist(raster, bins, palette, name, logger = NULL)
}
\arguments{
\item{raster}{SpatRaster object}

\item{bins}{The number of breaks in the histogram}

\item{palette}{character. The colour palette to use}

\item{name}{character. The name of the variable}

\item{logger}{Stores all notification messages to be displayed in the Log
Window. Insert the logger reactive list here for running in
shiny, otherwise leave the default NULL}
}
\value{
a function that generates a histogram
}
\description{
Called by the plot_hist module in the example app
and extracts values from a raster image, returning a histogram of density
}
\examples{
if (check_suggests(example = TRUE)) {
  raster <- terra::rast(ncol = 8, nrow = 8)
  raster[] <- sapply(1:terra::ncell(raster), function(x){
    rnorm(1, ifelse(x \%\% 8 != 0, x \%\% 8, 8), 3)})
  histogram <- plot_hist(raster, bins = 10, palette = "Greens", name = "Example")
  histogram()
} else {
  message('reinstall with install.packages("shinyscholar", dependencies = TRUE)
  to run this example')
}
}
\author{
Simon Smart \href{mailto:simon.smart@cantab.net}{simon.smart@cantab.net}
}
