% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.R
\name{anova.sjSDM}
\alias{anova.sjSDM}
\title{Anova / Variation partitioning}
\usage{
\method{anova}{sjSDM}(object, samples = 5000L, verbose = TRUE, ...)
}
\arguments{
\item{object}{model of object \code{\link{sjSDM}}}

\item{samples}{Number of Monte Carlo samples}

\item{verbose}{\code{TRUE} or \code{FALSE}, indicating whether progress should be printed or not}

\item{...}{optional arguments which are passed to the calculation of the logLikelihood}
}
\value{
An S3 class of type 'sjSDManova' including the following components:

\item{results}{Data frame of results.}
\item{to_print}{Data frame, summarized results for type I anova.}
\item{N}{Number of observations (sites).}
\item{spatial}{Logical, spatial model or not.}
\item{species}{individual species R2s.}
\item{sites}{individual site R2s.}
\item{lls}{individual site by species negative-log-likelihood values.}
\item{model}{model}

Implemented S3 methods are \code{\link{print.sjSDManova}} and \code{\link{plot.sjSDManova}}
}
\description{
Compute variance explained by the three fractions env, space, associations
}
\details{
The ANOVA function removes each of the three fractions (Environment, Space, Associations) and measures the drop in variance explained, and thus the importance of the three fractions.

Variance explained is measured by Deviance as well as the pseudo-R2 metrics of Nagelkerke and McFadden

In downstream functions such as \code{\link{plot.sjSDManova}} or \code{\link{plot.sjSDManova}} with \code{add_shared=TRUE}.
The anova can get unstable for many species and few occurrences/observations. We recommend using large numbers for 'samples'.
}
\examples{
\dontrun{
library(sjSDM)
# simulate community:
community = simulate_SDM(env = 3L, species = 10L, sites = 100L)

Occ <- community$response
Env <- community$env_weights
SP <- data.frame(matrix(rnorm(200, 0, 0.3), 100, 2)) # spatial coordinates


# fit model:
model <- sjSDM(Y = Occ, 
               env = linear(data = Env, formula = ~X1+X2+X3), 
               spatial = linear(data = SP, formula = ~0+X1*X2), 
               family=binomial("probit"),
               verbose = FALSE,
               iter = 20) # increase iter for real analysis

# Calculate ANOVA for env, space, associations, for details see ?anova.sjSDM
an = anova(model, samples = 10, verbose = FALSE) # increase iter for real analysis

# Show anova fractions
plot(an)

# ANOVA tables with different way to handle fractions
summary(an)
summary(an, fractions = "discard")
summary(an, fractions = "proportional")
summary(an, fractions = "equal")

# Internal structure
int = internalStructure(an, fractions = "proportional")

print(int)

plot(int) # default is negative values will be set to 0
plot(int, negatives = "scale") # global rescaling of all values to range 0-1
plot(int, negatives = "raw") # negative values will be discarded

plotAssemblyEffects(int)
plotAssemblyEffects(int, negatives = "floor")
plotAssemblyEffects(int, response = "sites", pred = as.factor(c(rep(1, 50), rep(2, 50))))
plotAssemblyEffects(int, response = "species", pred = runif(10))
plotAssemblyEffects(int, response = "species", pred = as.factor(c(rep(1, 5), rep(2, 5))))
}
}
\seealso{
\code{\link{plot.sjSDManova}}, \code{\link{print.sjSDManova}},\code{\link{summary.sjSDManova}}, \code{\link{plot.sjSDMinternalStructure}}
}
