% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal-utils.R
\name{spod_assert_package}
\alias{spod_assert_package}
\title{Checks if a package is installed and \emph{informs} the user if not}
\usage{
spod_assert_package(...)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[rlang:is_installed]{rlang::check_installed}}
  \describe{
    \item{\code{pkg}}{The package names. Can include version requirements,
e.g. \code{"pkg (>= 1.0.0)"}.}
    \item{\code{version}}{Minimum versions for \code{pkg}. If supplied, must be the
same length as \code{pkg}. \code{NA} elements stand for any versions.}
    \item{\code{compare}}{A character vector of comparison operators to use
for \code{version}. If supplied, must be the same length as
\code{version}. If \code{NULL}, \code{>=} is used as default for all
elements. \code{NA} elements in \code{compare} are also set to \code{>=} by
default.}
    \item{\code{reason}}{Optional string indicating why is \code{pkg} needed.
Appears in error messages (if non-interactive) and user prompts
(if interactive).}
    \item{\code{action}}{An optional function taking \code{pkg} and \code{...}
arguments. It is called by \code{check_installed()} when the user
chooses to update outdated packages. The function is passed the
missing and outdated packages as a character vector of names.}
    \item{\code{call}}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
  }}
}
\description{
This is wrapper around \link[rlang:is_installed]{rlang::check_installed};
instead of erroring out if the check fails it returns \code{FALSE}.
However, unlike \link[rlang:is_installed]{rlang::is_installed}, it emits a message to the user.
}
\keyword{internal}
