% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmrs.R
\name{glm_spec_fmrs_fl}
\alias{glm_spec_fmrs_fl}
\title{Perform first-level spectral GLM analysis of an fMRS dataset.}
\usage{
glm_spec_fmrs_fl(
  regressor_df,
  analysis_dir = "spant_analysis",
  exclude_labels = NULL,
  labels = NULL,
  xlim = c(4, 0.2),
  vline = c(1.35, 1.28, 2.35, 2.29),
  return_results = FALSE
)
}
\arguments{
\item{regressor_df}{a data frame containing temporal regressors to be applied
to each spectral datapoint.}

\item{analysis_dir}{directory containing preprocessed data generated by
the preproc_svs_dataset function.}

\item{exclude_labels}{vector of labels of scans to exclude, eg poor quality
data.}

\item{labels}{labels to describe each data set.}

\item{xlim}{spectral range to include in the analysis.}

\item{vline}{vertical lines to add to the plot.}

\item{return_results}{function will return key outputs, defaults to FALSE.}
}
\description{
Perform first-level spectral GLM analysis of an fMRS dataset.
}
