% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparegcv.R
\name{predict.spar.cv}
\alias{predict.spar.cv}
\title{predict.spar.cv}
\usage{
\method{predict}{spar.cv}(
  object,
  xnew = NULL,
  type = c("response", "link"),
  avg_type = c("link", "response"),
  opt_par = c("best", "1se"),
  nummod = NULL,
  nu = NULL,
  aggregate = c("mean", "median"),
  ...
)
}
\arguments{
\item{object}{result of spar function of class \code{'spar.cv'}.}

\item{xnew}{matrix of new predictor variables; must have same number of columns as  \code{x}.}

\item{type}{the type of required predictions; either on response level (default) or on link level}

\item{avg_type}{type of averaging the marginal models; either on link (default) or on response level}

\item{opt_par}{one of  \code{c("best","1se")}, chooses whether to select the
best pair of  \code{nus} and  \code{nummods} according to CV measure, or the
sparsest solution within one sd of that optimal CV measure;
ignored when  \code{nummod} and  \code{nu}, or  \code{coef} are given}

\item{nummod}{number of models used to form coefficients; value with
minimal validation  \code{Meas} is used if not provided.}

\item{nu}{threshold level used to form coefficients; value with minimal
validation  \code{Meas} is used if not provided.}

\item{aggregate}{character one of c("mean", "median");
the aggregation over the ensembles is done using the specified method (mean or median).
Defaults to mean aggregation.}

\item{...}{further arguments passed to or from other methods}
}
\value{
Vector of predictions
}
\description{
Predict responses for new predictors from \code{'spar.cv'} object
}
