% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_spatial_predictors.R
\name{get_spatial_predictors}
\alias{get_spatial_predictors}
\title{Gets the spatial predictors of a spatial model}
\usage{
get_spatial_predictors(model)
}
\arguments{
\item{model}{A model fitted with \code{\link[=rf_spatial]{rf_spatial()}}.}
}
\value{
A data frame with the spatial predictors included in the model.
}
\description{
Returns spatial predictors from a model fitted with \code{\link[=rf_spatial]{rf_spatial()}} in order of importance.
}
\examples{
if(interactive()){

 #loading example data
 data(distance_matrix)
 data(plant_richness_df)

 #fittind spatial model
 model <- rf_spatial(
   data = plant_richness_df,
   dependent.variable.name = "richness_species_vascular",
   predictor.variable.names = colnames(plant_richness_df)[5:21],
   distance.matrix = distance_matrix,
   distance.thresholds = c(0, 1000),
   n.cores = 1,
   method = "mem.moran.sequential"
 )

#getting data frame with the selected spatial predictors
spatial.predictors <- get_spatial_predictors(model)
head(spatial.predictors)

}
}
