% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/task_variogram_indic.R
\name{variogram_sews_predict}
\alias{variogram_sews_predict}
\alias{predict.variogram_sews_list}
\title{predict() method for variogram_sews objects}
\usage{
\method{predict}{variogram_sews_list}(object, newdist = NULL, ...)
}
\arguments{
\item{object}{An object produced by variogram_sews}

\item{newdist}{A vector of distances at which to return the variogram fit 
values (defaults to 128 regularly-spaced values).}

\item{...}{Additional arguments (ignored)}
}
\value{
A data.frame with the distances (column \code{dist}), the fitted 
  values (\code{gamma}), and if object contains more than one matrix, 
  a column \code{matrixn}.
}
\description{
Export the fitted variogram(s)
}
\examples{

\donttest{ 
vario_indics <- variogram_sews(serengeti)
predict(vario_indics)
vario_test <- indictest(vario_indics, nulln = 19)
predict(vario_test) # same result
}

}
\seealso{
\code{\link{variogram_sews}}
}
