% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/georange.R
\name{geo_ranges}
\alias{geo_ranges}
\title{Checks for geographic ranges from FishBase}
\usage{
geo_ranges(
  data,
  colsp = NULL,
  verbose = FALSE,
  pct = 90,
  sn = FALSE,
  warn = FALSE,
  synonym = fishbase(tables = "synonym"),
  ranges = fishbase(tables = "ranges")
)
}
\arguments{
\item{data}{Dataframe or vector to retrieve  ranges from FishBase.}

\item{colsp}{Column with species names from the data set.}

\item{verbose}{TRUE and messages will show. Default FALSE:}

\item{pct}{The percentage similarity of species names during standardization from FishBase.}

\item{sn}{TRUE and synonyms will be generated and not accepted ones. Default is FALSE, where species accepted names will be produced.}

\item{warn}{FALSE, not to generate warnings and TRUE for warnings. Default is FALSE:}

\item{synonym}{A standard database for species synonym names from FishBase. See \href{https://www.fishbase.se/}{FishBase} for more information.}

\item{ranges}{A standard database for ecological ranges from FishBase. See \href{https://www.fishbase.se/}{FishBase} for more information.}
}
\value{
Dataframe with geographical corrected ranges for species from FishBase.
}
\description{
Checks for geographic ranges from FishBase
}
\examples{

\dontrun{

gr <- geo_ranges(data= "Lates niloticus")

}


}
