% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/okpred.R
\name{okpred}
\alias{okpred}
\title{Generate spatial predictions using ordinary kriging (OK)}
\usage{
okpred(
  longlat,
  trainy,
  longlat2,
  nmax = 12,
  transformation = "none",
  delta = 1,
  vgm.args = ("Sph"),
  anis = c(0, 1),
  alpha = 0,
  block = 0,
  ...
)
}
\arguments{
\item{longlat}{a dataframe contains longitude and latitude of point
samples.}

\item{trainy}{a vector of response, must have length equal to the number of
rows in longlat.}

\item{longlat2}{a dataframe contains longitude and latitude of point locations
(i.e., the centres of grids) to be predicted.}

\item{nmax}{for local kriging: the number of nearest observations that
should be used for a kriging prediction or simulation, where nearest is
defined in terms of the space of the spatial locations. By default, 12
observations are used.}

\item{transformation}{transform the response variable to normalise the data;
can be "sqrt" for square root, "arcsine" for arcsine, "log" or "none"
for non transformation. By default, "none" is used.}

\item{delta}{numeric; to avoid log(0) in the log transformation.}

\item{vgm.args}{arguments for vgm, e.g. variogram model of response
variable and anisotropy parameters. see notes vgm in gstat for details.
By default, "Sph" is used.}

\item{anis}{anisotropy parameters: see notes vgm in gstat for details.}

\item{alpha}{direction in plane (x,y). see variogram in gstat for details.}

\item{block}{block size. see krige in gstat for details.}

\item{...}{other arguments passed on to gstat.}
}
\value{
A dataframe of longitude, latitude, predictions and variances.
}
\description{
This function is to make spatial predictions using ordinary
kriging.
}
\examples{
\dontrun{
library(sp)
data(swmud)
data(sw)
okpred1 <- okpred(swmud[, c(1,2)], swmud[, 3], sw, nmax = 7, transformation =
"arcsine", vgm.args = ("Sph"))
names(okpred1)
}

}
\references{
Pebesma, E.J., 2004. Multivariable geostatistics in S: the gstat
package. Computers & Geosciences, 30: 683-691.
}
\author{
Jin Li
}
