% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssMRCD_methods.R
\name{residuals.ssMRCD}
\alias{residuals.ssMRCD}
\title{Extracting Residuals from Local Fit}
\usage{
\method{residuals}{ssMRCD}(object, ...)
}
\arguments{
\item{object}{\code{ssMRCD} object, see \code{\link[ssMRCD]{ssMRCD}}.}

\item{...}{see details}
}
\value{
Returns either all residuals or the mean of the residual norms lower than the \code{alpha}- Quantile.
}
\description{
Extracting Residuals from Local Fit
}
\details{
Other input variables are: \tabular{ll}{
   \code{remove_outliers} \tab logical (default \code{FALSE}). If TRUE, only residuals
   from not outlying observations are calculated. If FALSE, trimmed residuals are used (see \code{alpha}). \cr
   \tab \cr
   \code{X} \tab matrix of new data, if data from the \code{ssMRCD} object is used. \cr
   \tab \cr
   \code{groups} \tab vector of groups for new data, if \code{NULL} data from the \code{ssMRCD} object is used. \cr
   \tab \cr
   \code{mean} \tab logical (default \code{FALSE}), specifying if mean of trimmed
   observations is returned or all residuals. \cr
}

If \code{X} and \code{groups} are provided, \code{alpha} is set to one and all residuals are used.
If \code{remove_outliers} is TRUE, \code{alpha} is set to 1 automatically.
}
\examples{
# create data set
x1 = matrix(runif(200), ncol = 2)
x2 = matrix(rnorm(200), ncol = 2)
x = list(x1, x2)

# create weighting matrix
W = matrix(c(0, 1, 1, 0), ncol = 2)

# calculate ssMRCD
localCovs = ssMRCD(x, weights = W, lambda = 0.5)

# residuals of model
residuals(localCovs, remove_outliers = TRUE, mean = FALSE)

# residuals of new data
residuals(localCovs,
      X = matrix(rnorm(20), ncol = 2, nrow = 10),
      groups = rep(2, 10),
      mean =TRUE)

}
