% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm.R
\name{starwars_dm}
\alias{starwars_dm}
\alias{starwars_dm_configure}
\title{Create a Star Wars Data Model Object}
\usage{
starwars_dm(configure_dm = TRUE, remote = FALSE)

starwars_dm_configure(dm)
}
\arguments{
\item{configure_dm}{If \code{TRUE} (default) the returned \pkg{dm} object is
completely configured with all of the primary and foreign keys. Set to
\code{FALSE} if you want to practice configuring the \pkg{dm} object yourself.}

\item{remote}{If \code{TRUE}, uses the internal DuckDB database rather than local
tables, which is the default.}

\item{dm}{A \pkg{dm} object with the starwarsdb tables}
}
\value{
A \pkg{dm} object
}
\description{
Creates a \pkg{dm} object with the starwarsdb tables.
}
\section{Functions}{
\itemize{
\item \code{starwars_dm_configure}: Configure the starwars \pkg{dm} object with primary
and foreign keys and colors.
}}

\examples{
# If the {dm} package is installed...
if (requireNamespace("dm", quietly = TRUE)) {
  # Create a full starwars {dm} object from local tables
  starwars_dm(remote = TRUE)

  # Create a base starwars {dm} object from remote tables wihout keys
  starwars_dm(configure_dm = FALSE, remote = TRUE)
}

}
\seealso{
\code{\link[dm:dm]{dm::dm()}}, \code{\link[dm:dm_add_pk]{dm::dm_add_pk()}}, \code{\link[dm:dm_add_fk]{dm::dm_add_fk()}}, \code{\link[dm:dm_from_src]{dm::dm_from_src()}}
}
