% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSpowerCurve.R
\name{SSpowerCurve}
\alias{SSpowerCurve}
\alias{powerCurve.fun}
\alias{NLS.powerCurve}
\alias{DRC.powerCurve}
\title{Power curve equation}
\usage{
powerCurve.fun(predictor, a, b)
NLS.powerCurve(predictor, a, b)
DRC.powerCurve(fixed = c(NA, NA), names = c("a", "b"))
}
\arguments{
\item{predictor}{a numeric vector of values at which to evaluate the model}

\item{a}{model parameter}

\item{b}{model parameter}

\item{fixed}{numeric vector. Specifies which parameters are fixed and at what value they are fixed. NAs for parameter that are not fixed.}

\item{names}{names. A vector of character strings giving the names of the parameters. The default is reasonable.}
}
\value{
powerCurve.fun() and NLS.powerCurve() return a numeric value,
while DRC.powerCurve() returns a list containing the nonlinear function, the self starter function
and the parameter names.
}
\description{
These functions provide the Power curve equation, that is also known
as the Freundlich equation and it is very used in agricultural chemistry,
e.g. to model the sorption of xenobiotics in soil. It is also used to model
the number of plant species as a function of sampling area
(Muller-Dumbois method). These functions provide the equation
('powerCurve.fun()') as well as the self-starters
for the \code{\link{nls}} function ( 'NLS.powerCurve()' ) and for the
\code{\link[drc]{drm}} function in the 'drc' package ('DRC.powerCurve()')
}
\details{
These functions provide the Power curve equation, that is parameterised as:
\deqn{ f(x) = a \, x^b }
which is totally equivalent to an exponential curve on the logarithm
of X:
\deqn{ f(x) = a \, \exp \left[ b \, \log(x) \right] }
We see that both parameters relate to the ‘slope’ of the curve and b
dictates its shape. If 0 < b < 1, the response Y increases as X
increases and the curve is convex up. If b < 0 the curve is concave
up and Y decreases as X increases. Otherwise, if b > 1, the curve is
concave up and Y increases as X increases.
}
\examples{
dataset <-getAgroData("speciesArea")

#nls fit
model <- nls(numSpecies ~ NLS.powerCurve(Area, a, b),
             data = dataset)
summary(model)
# drm fit
model <- drm(numSpecies ~ Area, fct = DRC.powerCurve(),
             data = dataset)
summary(model)

}
\references{
Ratkowsky, DA (1990) Handbook of nonlinear regression models. New York (USA): Marcel Dekker Inc.

Onofri, A. (2020). A collection of self-starters for nonlinear regression in R. See: \url{https://www.statforbiology.com/2020/stat_nls_usefulfunctions/}
}
\author{
Andrea Onofri
}
