% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumExtras-package.R
\docType{package}
\name{sumExtras-package}
\alias{sumExtras}
\alias{sumExtras-package}
\title{sumExtras: Extra Functions for 'gtsummary' Table Styling}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Provides additional convenience functions for 'gtsummary' (Sjoberg et al. (2021) \doi{10.32614/RJ-2021-053}) & 'gt' tables, including automatic variable labeling from dictionaries, standardized missing value display, and consistent formatting helpers for streamlined table styling workflows.

Provides additional convenience functions for 'gtsummary'
(Sjoberg et al. (2021) \url{doi:10.32614/RJ-2021-053}) & 'gt' tables,
including automatic variable labeling from dictionaries, standardized
missing value display, and consistent formatting helpers for streamlined
table styling workflows.
}
\section{Main Functions}{

\itemize{
\item \code{\link[=extras]{extras()}} - The signature function that adds overall columns, p-values, and clean styling
\item \code{\link[=clean_table]{clean_table()}} - Standardizes missing value display
\item \code{\link[=add_auto_labels]{add_auto_labels()}} - Smart automatic variable labeling from dictionaries or label attributes
\item \code{\link[=apply_labels_from_dictionary]{apply_labels_from_dictionary()}} - Set label attributes on data for cross-package workflows
\item \code{\link[=use_jama_theme]{use_jama_theme()}} - Apply JAMA compact theme to gtsummary tables
\item \code{\link[=theme_gt_compact]{theme_gt_compact()}} - JAMA-style compact themes for gt tables
\item \code{\link[=add_group_styling]{add_group_styling()}} - Enhanced text formatting for grouped tables
\item \code{\link[=add_group_colors]{add_group_colors()}} - Convenience function for group colors with automatic gt conversion
}
}

\section{Important Notes on Package Dependencies}{

\strong{gtsummary Internals:} This package depends on internal structures of the
gtsummary package (specifically \code{tbl$call_list}, \code{tbl$inputs}, and \code{tbl$table_body}).
While we make every effort to maintain compatibility, major updates to gtsummary
may require corresponding updates to sumExtras.

\strong{Minimum Versions:} Requires gtsummary >= 1.7.0 and gt >= 0.9.0. These minimum
versions ensure the necessary internal structures are available.

\strong{Testing:} We recommend testing your workflows after any gtsummary updates,
especially major version changes.
}

\examples{
\donttest{
# Basic workflow with extras()
gtsummary::trial |>
  gtsummary::tbl_summary(by = trt) |>
  extras()

# Complete workflow with styling
gtsummary::trial |>
  gtsummary::tbl_summary(by = trt, include = c(age, marker, grade, stage)) |>
  extras() |>
  gtsummary::add_variable_group_header(
    header = "Patient Characteristics",
    variables = age:stage
  ) |>
  add_group_styling() |>
  add_group_colors()
}

}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/kyleGrealis/sumExtras}
  \item Report bugs at \url{https://github.com/kyleGrealis/sumExtras/issues}
}


\itemize{
\item gtsummary package: \url{https://www.danieldsjoberg.com/gtsummary/}
\item Package website: \url{https://www.kyleGrealis.com/sumExtras/}
}
}
\author{
\strong{Maintainer}: Kyle Grealis \email{kyleGrealis@proton.me} (\href{https://orcid.org/0000-0002-9223-8854}{ORCID})

Other contributors:
\itemize{
  \item Raymond Balise \email{balise@miami.edu} (\href{https://orcid.org/0000-0002-9856-5901}{ORCID}) [contributor]
}

}
\keyword{internal}
