% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/successive-difference-replication.R
\name{make_sdr_replicate_factors}
\alias{make_sdr_replicate_factors}
\title{Factors for the Successive Difference Replication Method}
\usage{
make_sdr_replicate_factors(
  n,
  target_number_of_replicates,
  use_normal_hadamard = FALSE
)
}
\arguments{
\item{n}{The number of sampling units}

\item{target_number_of_replicates}{The target number of replicates to create.
This will determine the order of the Hadamard matrix to use when
creating replicate factors. The actual number of replicates will
be a multiple of 4.
If \code{use_normal_hadamard = FALSE}, then the actual number of replicates
will be \eqn{4 \times 2^k} for some integer \eqn{k}, 
which means that the actual number of replicates might be much larger than the target.}

\item{use_normal_hadamard}{Whether to use a normal Hadamard matrix:
that is, a matrix whose first row and first column only have entries
equal to 1.}
}
\value{
A matrix of replicate factors, with \code{n} rows
and the number of columns corresponding to the order of the Hadamard matrix used
(which is greater than or equal to \code{target_number_of_replicates}).
}
\description{
Create matrix of replicate factors to use for Successive Difference Replication Method
}
\examples{

# Note that one of the replicates has every factor equal to 1
# Also note that this matches Table 1 in Ash (2014)
make_sdr_replicate_factors(
  n = 4,
  target_number_of_replicates = 4,
  use_normal_hadamard = TRUE
)

# Note the difference when using a non-normal Hadamard matrix
rep_factors <- make_sdr_replicate_factors(
  n = 4,
  target_number_of_replicates = 4,
  use_normal_hadamard = FALSE
)
print(rep_factors)

# These replicate factors are equivalent
# to the SD2 variance estimator
tcrossprod(rep_factors - 1)

# Compare to the quadratic form of the SD2 estimator
sd2_quad_form <- make_quad_form_matrix(
  variance_estimator = "SD2",
  cluster_ids        = matrix(1:4, ncol = 1),
  sort_order         = matrix(1:4, ncol = 1)
)
print(sd2_quad_form)

}
