% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot_diversity.R
\docType{methods}
\name{she}
\alias{she}
\alias{she-method}
\alias{she,matrix-method}
\alias{she,data.frame-method}
\title{SHE Analysis}
\usage{
she(object, ...)

\S4method{she}{matrix}(
  object,
  unbiased = FALSE,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  sub = NULL,
  ann = graphics::par("ann"),
  axes = TRUE,
  frame.plot = axes,
  panel.first = NULL,
  panel.last = NULL,
  legend = list(x = "right"),
  ...
)

\S4method{she}{data.frame}(
  object,
  unbiased = FALSE,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  sub = NULL,
  ann = graphics::par("ann"),
  axes = TRUE,
  frame.plot = axes,
  panel.first = NULL,
  panel.last = NULL,
  legend = list(x = "right"),
  ...
)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each category, i.e. a contingency table). A \code{\link{data.frame}}
will be coerced to a \code{numeric} \code{matrix} via \code{\link[=data.matrix]{data.matrix()}}.}

\item{...}{Further \link[graphics:par]{graphical parameters} to be passed to
\code{\link[graphics:lines]{graphics::lines()}} and \code{\link[graphics:points]{graphics::points()}}.}

\item{unbiased}{A \code{\link{logical}} scalar: should the bias-corrected estimator be
used (see \code{\link[=index_shannon]{index_shannon()}})?}

\item{xlab, ylab}{A \code{\link{character}} vector giving the x and y axis labels.}

\item{main}{A \code{\link{character}} string giving a main title for the plot.}

\item{sub}{A \code{\link{character}} string giving a subtitle for the plot.}

\item{ann}{A \code{\link{logical}} scalar: should the default annotation (title and x,
y and z axis labels) appear on the plot?}

\item{axes}{A \code{\link{logical}} scalar: should axes be drawn on the plot?}

\item{frame.plot}{A \code{\link{logical}} scalar: should a box be drawn around the
plot?}

\item{panel.first}{An an \code{expression} to be evaluated after the plot axes are
set up but before any plotting takes place. This can be useful for drawing
background grids.}

\item{panel.last}{An \code{expression} to be evaluated after plotting has taken
place but before the axes, title and box are added.}

\item{legend}{A \code{\link{list}} of additional arguments to be passed to
\code{\link[graphics:legend]{graphics::legend()}}; names of the list are used as argument names.
If \code{NULL}, no legend is displayed.}
}
\value{
\code{she()} is called for its side-effects: it results in a graphic being
displayed (invisibly returns \code{object}).
}
\description{
SHE Analysis
}
\details{
If samples are taken along a gradient or stratigraphic section, breaks in
the curve may be used to infer discontinuities.

This assumes that the order of the matrix rows (from \eqn{1} to \eqn{n})
follows the progression along the gradient/transect.
}
\examples{
## Data from Conkey 1980, Kintigh 1989
data("cantabria")

## SHE analysis
she(cantabria)
}
\references{
Buzas, M. A. & Hayek, L.-A. C. (1998). SHE analysis for biofacies
identification. \emph{Journal of Foraminiferal Research}, 1998, 28(3), 233-239.

Hayek, L.-A. C. & Buzas, M. A. (2010). \emph{Surveying Natural Populations:
Quantitative Tools for Assessing Biodiversity}. Second edition.
New York: Columbia University Press.
}
\seealso{
Other diversity measures: 
\code{\link{diversity}()},
\code{\link{evenness}()},
\code{\link{heterogeneity}()},
\code{\link{occurrence}()},
\code{\link{plot.DiversityIndex}()},
\code{\link{plot.RarefactionIndex}()},
\code{\link{profiles}()},
\code{\link{rarefaction}()},
\code{\link{richness}()},
\code{\link{similarity}()},
\code{\link{simulate}()},
\code{\link{turnover}()}
}
\author{
N. Frerebeau
}
\concept{diversity measures}
