% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{circular_dispersion_boot}
\alias{circular_dispersion_boot}
\title{Bootstrapped Estimates for Circular Dispersion}
\usage{
circular_dispersion_boot(
  x,
  y = NULL,
  w = NULL,
  w.y = NULL,
  R = 1000,
  conf.level = 0.95,
  ...
)
}
\arguments{
\item{x}{numeric values in degrees.}

\item{y}{numeric. The angle(s) about which the angles \code{x} disperse (in degrees).}

\item{w, w.y}{(optional) Weights for \code{x} and \code{y}, respectively. A vector of
positive numbers and of the same length as \code{x}.}

\item{R}{The number of bootstrap replicates. positive integer
(1000 by default).}

\item{conf.level}{Level of confidence: \eqn{(1 - \alpha \%)/100}.
(\code{0.95} by default).}

\item{...}{optional arguments passed to \code{\link[boot:boot]{boot::boot()}}}
}
\value{
list containing:
\describe{
\item{\code{MLE}}{the maximum likelihood estimate of the circular dispersion}
\item{\code{sde}}{standard error of MLE}
\item{\code{CI}}{lower and upper limit of the confidence interval of MLE}
}
}
\description{
Calculates bootstrapped estimates of the circular dispersion,
its standard error and its confidence interval.
}
\examples{
data("nuvel1")
PoR <- subset(nuvel1, nuvel1$plate.rot == "na")
sa.por <- PoR_shmax(san_andreas, PoR, "right")
circular_dispersion(sa.por$azi.PoR, y = 135, w = 1 / san_andreas$unc)
circular_dispersion_boot(sa.por$azi.PoR, y = 135, w = 1 / san_andreas$unc, R = 1000)
}
\seealso{
\code{\link[=circular_dispersion]{circular_dispersion()}}
}
