% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_equi_mcmc.R
\name{random_ortho}
\alias{random_ortho}
\title{Generate a list of orthogonal matrices drawn from Haar distribution.}
\usage{
random_ortho(p)
}
\arguments{
\item{p}{A vector of dimensions for the matrices.}
}
\value{
\code{ortho_list} A list of orthogonal matrices whose dimensions are
  given in \code{p}.
}
\description{
Given a vector \code{p}, \code{random_ortho} will generate a list
\code{ortho_list} such that \code{ortho_list[[i]]} is a matrix with row and
column dimensions \code{p[[i]]} and is drawn from the uniform (Haar)
distribution over the space of orthogonal matrices.
}
\details{
This function is primarily used by \code{\link{multiway_takemura}} in its
averaging over uniformly minimum risk equivariant estimators under rotations
of the data array.
}
\seealso{
\code{\link{multiway_takemura}}.
}
\author{
David Gerard.
}
\keyword{equivariance}
\keyword{simulation}
