% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detvar.R
\name{CalendarVar}
\alias{CalendarVar}
\title{Calendar variables}
\usage{
CalendarVar(
  x,
  form = c("dif", "td", "td7", "td6", "wd", "wd2", "null"),
  ref = 0,
  lom = TRUE,
  lpyear = TRUE,
  easter = FALSE,
  len = 4,
  easter.mon = FALSE,
  n.ahead = 0
)
}
\arguments{
\item{x}{an object of class \code{ts} used to determine the sample period and
frequency.}

\item{form}{a character indicated the set of calendar variables: td, td7,
td6, wd.}

\item{ref}{a non-negative integer indicating the reference day.}

\item{lom}{logical. If TRUE length of the month effect is also estimated.}

\item{lpyear}{logical. If TRUE a leap year effect is also estimated.}

\item{easter}{logical. If TRUE an additional deterministic variable is
generated to capture Easter effects.}

\item{len}{duration of the Easter, integer.}

\item{easter.mon}{logical. It is TRUE if Holy Monday is a public holiday.}

\item{n.ahead}{number of additional observations to extend the sample period.}
}
\value{
An object of class \code{mts} or \code{ts}.
}
\description{
\code{CalendarVar} creates a set of deterministic variables to capture
calendar effects.
}
\examples{

Y <- rsales
X <- CalendarVar(Y, easter = TRUE)

}
\references{
Bell, W.R. and Hillmer, S.C. (1983) “Modeling time series with calendar
variation”, Journal of the American Statistical Society, Vol. 78, pp.
526–534.
}
