% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpc.R
\name{make_client}
\alias{make_client}
\title{Create client side thrift API}
\usage{
make_client(service, host = "localhost", port = 9090,
  proto_factory = TBinaryProtocolFactory$new(),
  trans_factory = TBufferedTransportFactory$new())
}
\arguments{
\item{service}{parsed service}

\item{host}{server host}

\item{port}{server tcp port}

\item{proto_factory}{factory that generates protocol implementation}

\item{trans_factory}{factory that generates transport implementation}
}
\description{
Create client side thrift API
}
\examples{
\dontrun{
# File calc.thrift content:
# service Calculator {
#   i32 add(1:i32 a, 2:i32 b);
#   i32 sub(1:i32 a, 2:i32 b);
#   i32 mult(1:i32 a, 2:i32 b);
#   i32 div(1:i32 a, 2:i32 b);
# }
#

calc_thrift <- thriftr::t_load("calc.thrift", module_name="calc_thrift")

cal <- thriftr::make_client(
    calc_thrift$Calculator,
    "127.0.0.1",
    6000)

a <- cal$mult(5, 2)
b <- cal$sub(7, 3)
c <- cal$sub(6, 4)
d <- cal$mult(b, 10)
e <- cal$add(a, d)
f <- cal$div(e, c)
print(f)
}
}
