% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_order_loci.R
\name{gt_order_loci}
\alias{gt_order_loci}
\title{Order the loci table of a gen_tibble}
\usage{
gt_order_loci(
  .x,
  use_current_table = FALSE,
  ignore_genetic_dist = TRUE,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{.x}{a \code{\link{gen_tibble}}}

\item{use_current_table}{boolean, if FALSE (the default), the table will be
reordered; if TRUE, then the current loci table, which might have been
reordered manually, will be used, but only if the positions within each
chromosome are sequential}

\item{ignore_genetic_dist}{boolean to ignore the genetic distance when
checking. Note that, if \code{genetic_dist} are being ignored and they are not
sorted, the function will set them to zero to avoid problems with other
software.}

\item{quiet}{boolean to suppress information about the files}

\item{...}{other arguments}
}
\value{
A \link{gen_tibble}
}
\description{
This function reorders the loci table so that positions within a chromosome
are sequential. It also re-saves the genotypes into a new file backed matrix
with the new order, so that it can be used by functions such as
\code{\link[=loci_ld_clump]{loci_ld_clump()}} and \code{\link[=gt_pca_autoSVD]{gt_pca_autoSVD()}}. If the loci table is already
ordered, the original \code{gen_tibble} is returned. This function will update the
backingfiles of the \code{gen_tibble} and return the \code{gen_tibble} object, use \verb{<-}
as per the example provided to ensure that the names of the newly updated
backingfiles are stored in the \code{gen_tibble} object.
}
\examples{
example_gt <- load_example_gt("gen_tbl") \%>\% select_loci(c(1, 5, 2, 6, 4, 3))

# Loci are in the wrong order
show_loci(example_gt)

# Reorder the loci, ignoring genetic distance
example_gt_ordered <- gt_order_loci(example_gt, ignore_genetic_dist = TRUE)

# Loci are now in the correct order
show_loci(example_gt_ordered)
}
