% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_add_text.R
\name{add_text}
\alias{add_text}
\title{Add text to a tidyprompt}
\usage{
add_text(prompt, text, position = c("after", "before"), sep = "\\n\\n")
}
\arguments{
\item{prompt}{A single string or a \code{\link[=tidyprompt]{tidyprompt()}} object}

\item{text}{Text to be added to the current prompt text}

\item{position}{Where to add the text; either "after" or "before".}

\item{sep}{Separator to be used between the current prompt text and the text to be added}
}
\value{
A \code{\link[=tidyprompt]{tidyprompt()}} with an added \code{\link[=prompt_wrap]{prompt_wrap()}} which
will append the text to the end of the current prompt text
}
\description{
Add text to a prompt by adding a \code{\link[=prompt_wrap]{prompt_wrap()}} which will append the text to
the before or after the current prompt text.
}
\examples{
prompt <- "Hi there!" |>
  add_text("How is your day?")
prompt
prompt |>
  construct_prompt_text()
}
\seealso{
Other pre_built_prompt_wraps: 
\code{\link{answer_as_boolean}()},
\code{\link{answer_as_integer}()},
\code{\link{answer_as_json}()},
\code{\link{answer_as_list}()},
\code{\link{answer_as_named_list}()},
\code{\link{answer_as_regex_match}()},
\code{\link{answer_as_text}()},
\code{\link{answer_by_chain_of_thought}()},
\code{\link{answer_by_react}()},
\code{\link{answer_using_r}()},
\code{\link{answer_using_sql}()},
\code{\link{answer_using_tools}()},
\code{\link{prompt_wrap}()},
\code{\link{quit_if}()},
\code{\link{set_system_prompt}()}

Other miscellaneous_prompt_wraps: 
\code{\link{quit_if}()},
\code{\link{set_system_prompt}()}
}
\concept{miscellaneous_prompt_wraps}
\concept{pre_built_prompt_wraps}
