% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/answer_using_tools.R
\name{tools_add_docs}
\alias{tools_add_docs}
\title{Add tidyprompt function documentation to a function}
\usage{
tools_add_docs(func, docs)
}
\arguments{
\item{func}{A function object}

\item{docs}{A list with the following elements:
\itemize{
\item 'name': (optional) The name of the function. If not provided, the function
name will be extracted from the function object. Use this parameter to override
the function name if necessary
\item 'description': A description of the function and its purpose
\item 'arguments': A named list of arguments with descriptions. Each argument is a list
which may contain: \itemize{
\item 'description': A description of the argument and its purpose. Not
required or used for native function calling (e.g., with OpenAI), but recommended
for text-based function calling
\item 'type': The type of the argument. This should be one of:
'integer', 'numeric', 'logical', 'string', 'match.arg',
'vector integer', 'vector numeric', 'vector logical', 'vector string'.
For arguments which are named lists, 'type' should be a named list
which contains the types of the elements. For type 'match.arg', the
possible values should be passed as a vector under 'default_value'.
'type' is required for native function calling (with, e.g., OpenAI) but may
also be useful to provide for text-based function calling, in which it will
be added to the prompt introducing the function
\item 'default_value': The default value of the argument. This is only required
when 'type' is set to 'match.arg'. It should then be a vector of possible values
for the argument. In other cases, it is not required; for native function calling,
it is not used in other cases; for text-based function calling, it may be useful
to provide the default value, which will be added to the prompt introducing the
function
}
\item 'return': A list with the following elements:
\itemize{
\item 'description': A description of the return value or the side effects of the function
}
}}
}
\value{
The function object with the documentation added as an attribute
('tidyprompt_tool_docs')
}
\description{
This function adds documentation to a custom function. This documentation
is used to extract information about the function's name, description, arguments,
and return value. This information is used to provide an LLM with information
about the functions, so that the LLM can call R functions. The intended
use of this function is to add documentation to custom functions that do not
have help files; \code{\link[=tools_get_docs]{tools_get_docs()}} may generate documentation from a
help file when the function is part of base R or a package.

If a function already has documentation, the documentation added by this
function may overwrite it. If you wish to modify existing documentation,
you may make a call to \code{\link[=tools_get_docs]{tools_get_docs()}} to extract the existing documentation,
modify it, and then call \code{\link[=tools_add_docs]{tools_add_docs()}} to add the modified documentation.
}
\examples{
\dontrun{
  # When using functions from base R or R packages,
  #   documentation is automatically extracted from help files:
  "What are the files in my current directory?" |>
    answer_using_tools(dir) |> # 'dir' function is from base R
    send_prompt()
}

# Custom functions may also be provided;
#   in this case, some documentation is extracted from the function's formals;
#   descriptions may be added manually. See below

# Example fake weather function to add to the prompt:
temperature_in_location <- function(
    location = c("Amsterdam", "Utrecht", "Enschede"),
    unit = c("Celcius", "Fahrenheit")
) {
  location <- match.arg(location)
  unit <- match.arg(unit)

  temperature_celcius <- switch(
    location,
    "Amsterdam" = 32.5,
    "Utrecht" = 19.8,
    "Enschede" = 22.7
  )

  if (unit == "Celcius") {
    return(temperature_celcius)
  } else {
    return(temperature_celcius * 9/5 + 32)
  }
}

# Generate documentation for a function
#   (based on formals, & help file if available)
docs <- tools_get_docs(temperature_in_location)

# The types get inferred from the function's formals
# However, descriptions are still missing as the function is not from a package
# We can modify the documentation object to add descriptions:
docs$description <- "Get the temperature in a location"
docs$arguments$unit$description <- "Unit in which to return the temperature"
docs$arguments$location$description <- "Location for which to return the temperature"
docs$return$description <- "The temperature in the specified location and unit"
# (See `?tools_add_docs` for more details on the structure of the documentation)

# When we are satisfied with the documentation, we can add it to the function:
temperature_in_location <- tools_add_docs(temperature_in_location, docs)

\dontrun{
  # Now the LLM can use the function:
  "Hi, what is the weather in Enschede? Give me Celcius degrees" |>
    answer_using_tools(temperature_in_location) |>
    send_prompt()
}
}
\seealso{
Other tools: 
\code{\link{answer_using_tools}()},
\code{\link{tools_get_docs}()}
}
\concept{tools}
