% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_water.R
\name{modify_water}
\alias{modify_water}
\alias{modify_water_chain}
\title{Modify a single slot in a \code{water} class object}
\usage{
modify_water(water, slot, value, units)

modify_water_chain(
  df,
  input_water = "defined_water",
  output_water = "modified_water",
  slot = "use_col",
  value = "use_col",
  units = "use_col"
)
}
\arguments{
\item{water}{A water class object}

\item{slot}{A character string of the slot in the water to modify, eg, "tthm"}

\item{value}{New value for the modified slot}

\item{units}{Units of the value being entered, typically one of c("mg/L", "ug/L", "M", "cm-1"). For ions any units supported by \link{convert_units}
are allowed. For organic carbon, one of "mg/L", "ug/L". For uv254 one of "cm-1", "m-1". For DBPs, one of "ug/L" or "mg/L".}

\item{df}{a data frame containing a water class column, which has already been computed using \link{define_water_chain}}

\item{input_water}{name of the column of water class data to be used as the input for this function. Default is "defined_water".}

\item{output_water}{name of the output column storing updated parameters with the class, water. Default is "modified_water".}
}
\value{
A data frame containing columns of selected parameters from a list of water class objects.

\code{modify_water_chain} returns a data frame containing a water class column with updated slot
}
\description{
This function a single slot of a \code{water} class object without impacting the other parameters. For example, you can
manually update "tthm" and the new speciation will not be calculated. This function is designed to make sure all parameters
are stored in the correct units when manually updating a water. Some slots cannot be modified with this function because
they are interconnected with too many others (usually pH dependent, eg, hco3). For those parameters, update \link{define_water}.
}
\examples{
water1 <- define_water(ph = 7, alk = 100, tds = 100, toc = 5) \%>\%
  modify_water(slot = "toc", value = 4, units = "mg/L")


library(dplyr)

example_df <- water_df \%>\%
  define_water_chain() \%>\%
  modify_water_chain(slot = "br", value = 50, units = "ug/L")

\donttest{
# Un-comment below to initialize parallel processing
# library(furrr)
# plan(multisession)
example_df <- water_df \%>\%
  define_water_chain() \%>\%
  mutate(bromide = rep(c(20, 30, 50), 4)) \%>\%
  modify_water_chain(slot = "br", value = bromide, units = "ug/L")

# Optional: explicitly close multisession processing
# plan(sequential)
}
}
