% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conama.R
\name{conama_limits}
\alias{conama_limits}
\title{Limits for Brazilian CONAMA 357/2005}
\usage{
conama_limits(class)
}
\arguments{
\item{class}{Integer or character. Target class (e.g., 1, 2, 3, 4 or "special"),
according to CONAMA 357/2005.}
}
\value{
A tibble/data frame with one row per parameter and regulatory thresholds.
Typical columns:
\itemize{
\item \code{parametro}: parameter name (character, normalized to snake_case)
\item \code{classe}: class label (character)
\item \code{min}/\code{max} (or equivalents): numeric thresholds (may be \code{NA})
\item other metadata columns if present (e.g., unit, criterion)
}
}
\description{
Returns the parameter limits defined by CONAMA Resolution 357/2005
for a given water-use class.
}
\examples{
# Class 2 thresholds (first rows)
head(conama_limits(2))

}
