% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipes-step_ts_pad.R
\name{step_ts_pad}
\alias{step_ts_pad}
\alias{tidy.step_ts_pad}
\title{Pad: Add rows to fill gaps and go from low to high frequency}
\usage{
step_ts_pad(
  recipe,
  ...,
  by = "day",
  pad_value = NA,
  role = "predictor",
  trained = FALSE,
  columns = NULL,
  skip = FALSE,
  id = rand_id("ts_padding")
)

\method{tidy}{step_ts_pad}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{A single column with class \code{Date} or
\code{POSIXct}. See \code{\link[recipes:selections]{recipes::selections()}} for more details.
For the \code{tidy} method, these are not currently used.}

\item{by}{Either "auto", a time-based frequency like "year", "month", "day", "hour", etc,
or a time expression like "5 min", or "7 days". See Details.}

\item{pad_value}{Fills in padded values. Default is \code{NA}.}

\item{role}{For model terms created by this step, what analysis
role should they be assigned?. By default, the function assumes
that the new variable columns created by the original variables
will be used as predictors in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{columns}{A character string of variables that will be
used as inputs. This field is a placeholder and will be
populated once \code{recipes::prep()} is used.}

\item{skip}{A logical. Should the step be skipped when the recipe is
baked by bake.recipe()? While all operations are baked when prep.recipe()
is run, some operations may not be able to be conducted on new data
(e.g. processing the outcome variable(s)). Care should be taken when
using skip = TRUE as it may affect the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_ts_pad} object.}
}
\value{
For \code{step_ts_pad}, an updated version of recipe with
the new step added to the sequence of existing steps (if any).
For the \code{tidy} method, a tibble with columns \code{terms}
(the selectors or variables selected), \code{value} (the feature
names).
}
\description{
\code{step_ts_pad} creates a a \emph{specification} of a recipe
step that will analyze a Date or Date-time column adding rows
at a specified interval.
}
\details{
\strong{Date Variable}
\itemize{
\item Only one date or date-time variable may be supplied.
\item \verb{step_ts_pad())} does \emph{not} remove the original date variables.
}

\strong{Interval Specification (by)}

Padding can be applied in the following ways:
\itemize{
\item The eight intervals in are: year, quarter, month, week, day, hour, min, and sec.
\item Intervals like 30 minutes, 1 hours, 14 days are possible.
}

\strong{Imputing Missing Values}

The generic \code{pad_value} defaults to \code{NA}, which typically requires imputation.
Some common strategies include:
\itemize{
\item \strong{Numeric data:} The \code{step_ts_impute()} preprocessing step can be used to impute
numeric time series data with or without seasonality
\item \strong{Nominal data:} The \code{step_mode_impute()} preprocessing step can be used to replace
missing values with the most common value.
}
}
\examples{
library(recipes)
library(dplyr)

FB_tbl <- FANG \%>\%
    filter(symbol == "FB") \%>\%
    select(symbol, date, adjusted)


rec_obj <- recipe(adjusted ~ ., data = FB_tbl) \%>\%
    step_ts_pad(date, by = "day", pad_value = NA)

# View the recipe object
rec_obj

# Prepare the recipe object
prep(rec_obj)

# Bake the recipe object - Adds the padding
bake(prep(rec_obj), FB_tbl)

# Tidy shows which features have been added during the 1st step
#  in this case, step 1 is the step_timeseries_signature step
tidy(prep(rec_obj))
tidy(prep(rec_obj), number = 1)

}
\seealso{
Padding & Imputation:
\itemize{
\item Pad Time Series: \code{\link[=step_ts_pad]{step_ts_pad()}}
\item Impute missing values with these: \code{\link[=step_ts_impute]{step_ts_impute()}}, \code{\link[=step_ts_clean]{step_ts_clean()}}
}

Time Series Analysis:
\itemize{
\item Engineered Features: \code{\link[=step_timeseries_signature]{step_timeseries_signature()}}, \code{\link[=step_holiday_signature]{step_holiday_signature()}}, \code{\link[=step_fourier]{step_fourier()}}
\item Diffs & Lags \code{\link[=step_diff]{step_diff()}}, \code{recipes::step_lag()}
\item Smoothing: \code{\link[=step_slidify]{step_slidify()}}, \code{\link[=step_smooth]{step_smooth()}}
\item Variance Reduction: \code{\link[=step_box_cox]{step_box_cox()}}
}

Main Recipe Functions:
\itemize{
\item \code{recipes::recipe()}
\item \code{recipes::prep}
\item \code{recipes::bake}
}
}
\concept{dates}
\concept{model_specification}
\concept{preprocessing}
