% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{apply_tensor}
\alias{apply_tensor}
\title{Apply windowing and weighting to context data for network accumulation (C++ backend)}
\usage{
apply_tensor(
  tensor,
  dims,
  dims_sender,
  dims_receiver,
  dims_mode,
  context_matrix,
  unit_rows,
  codes,
  times,
  ordered = TRUE
)
}
\arguments{
\item{tensor}{NumericVector. The multi-dimensional context_tensor array created in R can be supplied as-is; it is automatically converted to a 1D vector when passed to this function via Rcpp.}

\item{dims}{IntegerVector. The dimensions of the original context_tensor array.}

\item{dims_sender}{std::vector<int>. Indices of sender dimensions in the array.}

\item{dims_receiver}{std::vector<int>. Indices of receiver dimensions in the array.}

\item{dims_mode}{std::vector<int>. Indices of mode dimensions in the array.}

\item{context_matrix}{NumericMatrix. Matrix representation of the context for a single unit (rows = context lines, columns = factors).}

\item{unit_rows}{std::vector<int>. Indices of the response rows for the unit in the context.}

\item{codes}{arma::mat. Matrix of codes (nrow = context lines, ncol = number of codes).}

\item{times}{NumericVector. Vector of time values for each context line.}

\item{ordered}{bool. If TRUE, returns a full adjacency matrix; if FALSE, returns only upper triangle (ENA style).}
}
\value{
A list with two elements:
  - row_connection_counts: A matrix of connection counts for each response line (rows = response lines, columns = connections).
  - connection_counts: A vector of accumulated connection counts for the unit (length = number of connections).
}
\description{
This function implements the core logic for accumulating network connections using a multidimensional parameter array (context_tensor),
efficiently applying window and weight parameters to each response line in a unit's context. It is designed for use in the TMA package
to speed up accumulation calculations by leveraging C++ and Armadillo for matrix operations.
}
